class Respawnables_Pickup extends TournamentPickup;

var Pawn Fragger;
var int LifeTime;
var int Money;

event float BotDesireability(Pawn Bot)
{
	if ( Bot == Fragger )
		return (10);
	else
		return (0); 
}

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessageHealthPlus', 0, None, None, Self.Class );
}

auto state Pickup
{	
	function Touch( actor Other )
	{
		if ( ValidTouch(Other) && Other.IsA('PlayerPawn') && Other == Fragger ) 
			{
			Respawnables_PRI(PlayerPawn(Other).PlayerReplicationInfo).Money += Money;
			PlayPickupMessage(Pawn(Other));
			PlaySound(PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();	
			}
		else if ( ValidTouch(Other) && Other.IsA('Bot') && Other == Fragger ) 
			{
			PlaySound(PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();
			}
	}
}


defaultproperties
{
Money=10
LifeTime=60
DrawType=DT_Sprite
CollisionRadius=32.00000
CollisionHeight=32.00000
Texture=Texture'Frag10'
PickupMessage="+$10"
ItemName="Respawnables Pickup"
RespawnTime=0.000000
PickupSound=Sound'BotPack.Pickups.UTHealth'
ScaleGlow=2.000000
bCollideWhenPlacing=True
RespawnTime=0
DrawScale=0.25
}
